/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UDynLink.h,v 1.6 2000/01/07 07:46:57 nryan Exp $
____________________________________________________________________________*/

// FormatEx calling parameters and associated structures and enums originally
// reverse-engineered by Mark Russinovich (http://www.sysinternals.com).

#ifndef Included_UDynLink_h	// [
#define Included_UDynLink_h

#include "pgpClassesConfig.h"
#include <tchar.h>

_PGP_BEGIN

namespace UDynLink
{
	// From Lmcons.h.

	enum
	{
		NERR_Success	= 0, 		// Success

		LM20_NNLEN		= 12, 		// LM 2.0 Net name length
		MAXCOMMENTSZ	= 256, 		// Multipurpose comment length
		SHPWLEN			= 8			// Share password length (bytes)
	};

	// FormatEx: output command structure

	struct FormatExTextOutput 
	{
		DWORD	lines;
		PCHAR	output;
	};

	// FormatEx: callback command types

	enum FormatExCallbackCommand 
	{
		kFMIFS_ProgressCmd			= 0,
		kFMIFS_DoneWithStructureCmd	= 1,
		kFMIFS_Unknown2				= 2,
		kFMIFS_Unknown3				= 3,
		kFMIFS_Unknown4				= 4,
		kFMIFS_Unknown5				= 5,
		kFMIFS_InsufficientRights	= 6,
		kFMIFS_Unknown7				= 7,
		kFMIFS_Unknown8				= 8,
		kFMIFS_Unknown9				= 9,
		kFMIFS_UnknownA				= 10,
		kFMIFS_Done					= 11,
		kFMIFS_UnknownC				= 12,
		kFMIFS_UnknownB				= 13,
		kFMIFS_Output				= 14,
		kFMIFS_StructureProgress	= 15
	};

	// FormatEx: media type defines

	enum FormatExMediaType
	{
		kFMIFS_FloppyType	= 0x8, 
		kFMIFS_HardDiskType	= 0xC
	};

	// FormatEx: FMIFS callback definition

	typedef BOOLEAN (__stdcall *PFMIFSCALLBACK)(
		FormatExCallbackCommand command, DWORD subAction, PVOID actionInfo);

	// From Svrapi.h

	struct share_info_50 
	{
		char			shi50_netname[LM20_NNLEN+1];
		unsigned char 	shi50_type; 
		unsigned short	shi50_flags;
		char FAR *		shi50_remark;
		char FAR *		shi50_path;
		char			shi50_rw_password[SHPWLEN+1];
		char			shi50_ro_password[SHPWLEN+1];

	};

	// From Lmshare.h

	typedef struct _SHARE_INFO_2 
	{
		LPWSTR  shi2_netname;
		DWORD   shi2_type;
		LPWSTR  shi2_remark;
		DWORD   shi2_permissions;
		DWORD   shi2_max_uses;
		DWORD   shi2_current_uses;
		LPWSTR  shi2_path;
		LPWSTR  shi2_passwd;

	} SHARE_INFO_2, *PSHARE_INFO_2, *LPSHARE_INFO_2;


	// Functions

	long	BroadcastSystemMessage(DWORD dwFlags, LPDWORD lpdwRecipients, 
		UINT uiMessage, WPARAM wParam, LPARAM lParam);

	BOOL	GetDiskFreeSpaceEx(LPCTSTR lpDirectoryName, 
		PULARGE_INTEGER lpFreeBytesAvailableToCaller, 
		PULARGE_INTEGER lpTotalNumberOfBytes, 
		PULARGE_INTEGER lpTotalNumberOfFreeBytes);

	DWORD	Win95_NetShareGetInfo(const char FAR *pszServer, 
		const char FAR *pszNetName, short sLevel, char FAR *pbBuffer, 
		unsigned short cbBuffer, unsigned short FAR * pcbTotalAvail);
	DWORD	Win95_WNetCloseEnum(HANDLE hEnum);
	DWORD	Win95_WNetEnumResource(HANDLE hEnum, LPDWORD lpcCount, 
		LPVOID lpBuffer, LPDWORD lpBufferSize);
	BOOL	Win95_WNetGetUniversalName(LPCSTR szDrive, LPTSTR szUniv);
	DWORD	Win95_WNetOpenEnum(DWORD dwScope, DWORD dwType, 
		DWORD dwUsage, LPNETRESOURCE lpNetResource, LPHANDLE lphEnum);
	
	VOID	WinNT_FormatEx(PWCHAR driveRoot, DWORD mediaFlag, PWCHAR format, 
		PWCHAR label, BOOL quickFormat, DWORD clusterSize, 
		PFMIFSCALLBACK callback);
	DWORD	WinNT_NetApiBufferFree(LPVOID Buffer);
	DWORD	WinNT_NetShareGetInfo(LPWSTR servername, LPWSTR netname, 
		DWORD level, LPBYTE *bufptr);
	DWORD	WinNT_WNetGetUniversalName(LPCTSTR lpLocalPath, 
		DWORD dwInfoLevel, LPVOID lpBuffer, LPDWORD lpBufferSize);

	BOOL	WinNT_OpenProcessToken(HANDLE ProcessHandle, 
		DWORD DesiredAccess, PHANDLE TokenHandle);
	BOOL	WinNT_OpenThreadToken(HANDLE ThreadHandle, DWORD DesiredAccess, 
		BOOL OpenAsSelf, PHANDLE TokenHandle);

	BOOL	WinNT_GetTokenInformation(HANDLE TokenHandle, 
		TOKEN_INFORMATION_CLASS TokenInformationClass, 
		LPVOID TokenInformation, DWORD TokenInformationLength, 
		PDWORD ReturnLength);

	BOOL	WinNT_AllocateAndInitializeSid(
		PSID_IDENTIFIER_AUTHORITY pIdentifierAuthority, 
		BYTE nSubAuthorityCount, DWORD nSubAuthority0, DWORD nSubAuthority1, 
		DWORD nSubAuthority2, DWORD nSubAuthority3, DWORD nSubAuthority4, 
		DWORD nSubAuthority5, DWORD nSubAuthority6, DWORD nSubAuthority7, 
		PSID *pSid);
	BOOL	WinNT_EqualSid(PSID pSid1, PSID pSid2);
	PVOID	WinNT_FreeSid(PSID pSid);

	BOOL	Win2k_GetVolumeNameForVolumeMountPoint(
		LPCTSTR lpszVolumeMountPoint, LPTSTR lpszVolumeName, 
		DWORD cchBufferLength);
	BOOL	Win2k_GetVolumePathName(LPCTSTR lpszFileName, 
		LPTSTR lpszVolumePathName, DWORD cchBufferLength);
	BOOL	Win2k_SetVolumeMountPoint(LPCTSTR lpszVolumeMountPoint, 
		LPCTSTR lpszVolumeName);
	BOOL	Win2k_DeleteVolumeMountPoint(LPCTSTR lpszVolumeMountPoint);
}

_PGP_END

#endif	// ] Included_UDynLink_h
